%% Newtonverfahren mit Armijo/Powell-Schrittweite:

function [xk,fxk] = trustregion(f,x0,tol)

    %options = optimoptions('fmincon','Display','none'); %,'Algorithm','sqp');

    xk = x0;
    steps = 0;
    global A                                                               % zur Speicherung der xk
    A = xk;
    [~,gk,~] = f(xk);                                                      % exakten Gradienten bestimmen
    
    % Festlegung der Konstanten des T-R-Verfahrens:
    delta1 = 0.1;
    delta2 = 0.75;
    sigma1 = 0.5;
    sigma2 = 2;
    rho = 10; 
    
    while norm(gk) > tol
    
        steps = steps + 1;
        
        % Lösen des Hilfsproblems:
        [~,gk,Hk] = f(xk); 
        nonlcon = @(d) constraints(rho,d);
        dk = sqp(xk,@(d) fk(f,xk,gk,Hk,d),[],nonlcon,[],[]);
        
        if f(xk)-fk(f,xk,gk,Hk,dk) < tol^2
          
            disp("Abbruch, da Lösung bereits gefunden!");
            break
          
        else
          
            rk = (f(xk)-f(xk+dk))/(f(xk)-fk(f,xk,gk,Hk,dk));
            
        end
        
        % Wahl von rho für nächsten Schritt:
        if rk < delta1
            
            rho = sigma1*rho;
            
        elseif rk >= delta1 && rk <= delta2
            
            xk = xk + dk;
            [~,gk,~] = f(xk);  
            
        elseif rk > delta2
            
            xk = xk + dk;
            rho = sigma2*rho;
            [~,gk,~] = f(xk);  
            
        end
        
        A(:,steps+1) = xk;
     
    end
    
    fxk = f(xk);
    
    disp(steps);

end